# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from ...base.types.email_address import EmailAddress
import pydantic
from .location import Location
from .domain_contact_type_id import DomainContactTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class DomainContact(UncheckedBaseModel):
    """
    The contact information related to a domain registration, e.g., registrant, administrator, abuse, billing, or technical contact.
    """

    email_addr: typing.Optional[EmailAddress] = pydantic.Field(default=None)
    """
    The user's primary email address.
    """

    location: typing.Optional[Location] = pydantic.Field(default=None)
    """
    Location details for the contract such as the city, state/province, country, etc.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The individual or organization name for the contact.
    """

    phone_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    The number associated with the phone.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Domain Contact type, normalized to the caption of the <code>type_id</code> value. In the case of 'Other', it is defined by the source
    """

    type_id: DomainContactTypeId = pydantic.Field()
    """
    The normalized domain contact type ID.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the contact information, typically provided in WHOIS information.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
