# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from ...base.types.timestamp import Timestamp
import pydantic
import datetime as dt
from .file import File
from .group import Group
from .databucket_type_id import DatabucketTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Databucket(UncheckedBaseModel):
    """
    The databucket object is a basic container that holds data, typically organized through the use of data partitions.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the databucket was known to have been created.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the databucket was known to have been created.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the databucket.
    """

    file: typing.Optional[File] = pydantic.Field(default=None)
    """
    A file within a databucket.
    """

    groups: typing.Optional[typing.List[Group]] = pydantic.Field(default=None)
    """
    The group names to which the databucket belongs.
    """

    modified_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The most recent time when any changes, updates, or modifications were made within the databucket.
    """

    modified_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The most recent time when any changes, updates, or modifications were made within the databucket.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The databucket name.
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The size of the databucket in bytes.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The databucket type.
    """

    type_id: DatabucketTypeId = pydantic.Field()
    """
    The normalized identifier of the databucket type.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the databucket.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
