# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .device import Device
from .email import Email
from .group import Group
from .organization import Organization
from .policy import Policy
from .managed_entity_type_id import ManagedEntityTypeId
from .user import User
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class ManagedEntity(UncheckedBaseModel):
    """
    The Managed Entity object describes the type and version of an entity, such as a user, device, or policy. For types in the <code>type_id</code> enum list, an associated attribute should be populated. If the type of entity is not in the <code>type_id</code> list, information can be put into the <code>data</code> attribute and the <code>type</code> attribute should identify the entity.
    """

    data: typing.Optional[typing.Optional[typing.Any]] = pydantic.Field(default=None)
    """
    The managed entity content as a JSON object.
    """

    device: typing.Optional[Device] = pydantic.Field(default=None)
    """
    An addressable device, computer system or host.
    """

    email: typing.Optional[Email] = pydantic.Field(default=None)
    """
    The email object.
    """

    group: typing.Optional[Group] = pydantic.Field(default=None)
    """
    The group object associated with an entity such as user, policy, or rule.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the managed entity.
    """

    org: typing.Optional[Organization] = pydantic.Field(default=None)
    """
    Organization and org unit relevant to the event or object.
    """

    policy: typing.Optional[Policy] = pydantic.Field(default=None)
    """
    Describes details of a managed policy.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The managed entity type. For example: <code>policy</code>, <code>user</code>, <code>organizational unit</code>, <code>device</code>.
    """

    type_id: typing.Optional[ManagedEntityTypeId] = pydantic.Field(default=None)
    """
    The type of the Managed Entity. It is recommended to also populate the <code>type</code> attribute with the associated label, or the source specific name if <code>Other</code>.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The identifier of the managed entity.
    """

    user: typing.Optional[User] = pydantic.Field(default=None)
    """
    The user that pertains to the event or object.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the managed entity. For example: <code>1.2.3</code>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
