# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .url_category_ids import UrlCategoryIds
from ...base.types.hostname import Hostname
from ...base.types.port import Port
from ...base.types.url_string import UrlString
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Url(UncheckedBaseModel):
    """
    The Uniform Resource Locator(URL) object describes the characteristics of a URL. Defined in <a target='_blank' href='https://datatracker.ietf.org/doc/html/rfc1738'>RFC 1738</a> and by D3FEND <a target='_blank' href='https://d3fend.mitre.org/dao/artifact/d3f:URL/'>d3f:URL</a>.
    """

    categories: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The Website categorization names, as defined by <code>category_ids</code> enum values.
    """

    category_ids: typing.Optional[typing.List[UrlCategoryIds]] = pydantic.Field(
        default=None
    )
    """
    The Website categorization identifiers.
    """

    domain: typing.Optional[str] = pydantic.Field(default=None)
    """
    The domain portion of the URL. For example: <code>example.com</code> in <code>https://sub.example.com</code>.
    """

    hostname: typing.Optional[Hostname] = pydantic.Field(default=None)
    """
    The URL host as extracted from the URL. For example: <code>www.example.com</code> from <code>www.example.com/download/trouble</code>.
    """

    path: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL path as extracted from the URL. For example: <code>/download/trouble</code> from <code>www.example.com/download/trouble</code>.
    """

    port: typing.Optional[Port] = pydantic.Field(default=None)
    """
    The URL port. For example: <code>80</code>.
    """

    query_string: typing.Optional[str] = pydantic.Field(default=None)
    """
    The query portion of the URL. For example: the query portion of the URL <code>http://www.example.com/search?q=bad&sort=date</code> is <code>q=bad&sort=date</code>.
    """

    resource_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The context in which a resource was retrieved in a web request.
    """

    scheme: typing.Optional[str] = pydantic.Field(default=None)
    """
    The scheme portion of the URL. For example: <code>http</code>, <code>https</code>, <code>ftp</code>, or <code>sftp</code>.
    """

    subdomain: typing.Optional[str] = pydantic.Field(default=None)
    """
    The subdomain portion of the URL. For example: <code>sub</code> in <code>https://sub.example.com</code> or <code>sub2.sub1</code> in <code>https://sub2.sub1.example.com</code>.
    """

    url_string: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The URL string. See RFC 1738. For example: <code>http://www.example.com/download/trouble.exe</code>. Note: The URL path should not populate the URL string.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
