# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .account import Account
import pydantic
from .organization import Organization
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Cloud(UncheckedBaseModel):
    """
    The Cloud object contains information about a cloud account such as AWS Account ID, regions, etc.
    """

    account: typing.Optional[Account] = pydantic.Field(default=None)
    """
    The account object describes details about the account that was the source or target of the activity.
    """

    org: typing.Optional[Organization] = pydantic.Field(default=None)
    """
    Organization and org unit relevant to the event or object.
    """

    project_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of a Cloud project.
    """

    provider: str = pydantic.Field()
    """
    The unique name of the Cloud services provider, such as AWS, MS Azure, GCP, etc.
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the cloud region, as defined by the cloud provider.
    """

    zone: typing.Optional[str] = pydantic.Field(default=None)
    """
    The availability zone in the cloud region, as defined by the cloud provider.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
