# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ...base.types.email_address import EmailAddress
from .file import File
from ...base.types.timestamp import Timestamp
import datetime as dt
from ...base.types.ip_address import IpAddress
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Email(UncheckedBaseModel):
    """
    The Email object describes the email metadata such as sender, recipients, and direction. Defined by D3FEND <a target='_blank' href='https://d3fend.mitre.org/dao/artifact/d3f:Email/'>d3f:Email</a>.
    """

    bcc: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The BCC recipients of the email. Similar to cc field but for BCC recipients.
    """

    cc: typing.Optional[typing.List[EmailAddress]] = pydantic.Field(default=None)
    """
    The email header Cc values, as defined by RFC 5322.
    """

    delivered_to: typing.Optional[EmailAddress] = pydantic.Field(default=None)
    """
    The <strong>Delivered-To</strong> email header field.
    """

    files: typing.Optional[typing.List[File]] = pydantic.Field(default=None)
    """
    The files that are part of the event or object.
    """

    from_: EmailAddress = pydantic.Field(alias="from")
    """
    The email header From values, as defined by RFC 5322.
    """

    is_externally_viewable: typing.Optional[bool] = pydantic.Field(default=None)
    """
    True if the email is viewable externally (presumably by external users).
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Labels associated with the object, such as security or sensitivity labels created by a scanning app.
    """

    message_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email header Message-Id value, as defined by RFC 5322.
    """

    raw_header: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email authentication header.
    """

    reply_to: typing.Optional[EmailAddress] = pydantic.Field(default=None)
    """
    The email header Reply-To values, as defined by RFC 5322.
    """

    sender_mailbox_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique ID of the sender mailbox. This is distinct from the sender's email address.
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The size in bytes of the email, including attachments.
    """

    smtp_from: typing.Optional[EmailAddress] = pydantic.Field(default=None)
    """
    The value of the SMTP MAIL FROM command.
    """

    smtp_to: typing.Optional[typing.List[EmailAddress]] = pydantic.Field(default=None)
    """
    The value of the SMTP envelope RCPT TO command.
    """

    subject: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email header Subject value, as defined by RFC 5322.
    """

    time_sent: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time at which the email was sent.
    """

    time_sent_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time at which the email was sent.
    """

    to: typing.List[EmailAddress] = pydantic.Field()
    """
    The email header To values, as defined by RFC 5322.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email unique identifier.
    """

    x_originating_ip: typing.Optional[typing.List[IpAddress]] = pydantic.Field(
        default=None
    )
    """
    The X-Originating-IP header identifying the emails originating IP address(es).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
