# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .network_endpoint import NetworkEndpoint
from .endpoint_connection import EndpointConnection
from ...base.types.ip_address import IpAddress
from .metric import Metric
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class LoadBalancer(UncheckedBaseModel):
    """
    The load balancer object describes the load balancer entity and contains additional information regarding the distribution of traffic across a network.
    """

    classification: typing.Optional[str] = pydantic.Field(default=None)
    """
    The request classification as defined by the load balancer.
    """

    code: typing.Optional[int] = pydantic.Field(default=None)
    """
    The numeric response status code detailing the connection from the load balancer to the destination target.
    """

    dst_endpoint: typing.Optional[NetworkEndpoint] = pydantic.Field(default=None)
    """
    The destination to which the load balancer is distributing traffic.
    """

    endpoint_connections: typing.Optional[typing.List[EndpointConnection]] = (
        pydantic.Field(default=None)
    )
    """
    An object detailing the load balancer connection attempts and responses.
    """

    error_message: typing.Optional[str] = pydantic.Field(default=None)
    """
    The load balancer error message.
    """

    ip: typing.Optional[IpAddress] = pydantic.Field(default=None)
    """
    The IP address of the load balancer node that handled the client request. Note: the load balancer may have other IP addresses, and this is not an IP address of the target/distribution endpoint - see <code>dst_endpoint</code>.
    """

    message: typing.Optional[str] = pydantic.Field(default=None)
    """
    The load balancer message.
    """

    metrics: typing.Optional[typing.List[Metric]] = pydantic.Field(default=None)
    """
    General purpose metrics associated with the load balancer.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the load balancer.
    """

    status_detail: typing.Optional[str] = pydantic.Field(default=None)
    """
    The status detail contains additional status information about the load balancer distribution event.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier for the load balancer.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
