# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class NetworkTraffic(UncheckedBaseModel):
    """
    The Network Traffic object describes characteristics of network traffic. Network traffic refers to data moving across a network at a given point of time. Defined by D3FEND <a target='_blank' href='https://d3fend.mitre.org/dao/artifact/d3f:NetworkTraffic/'>d3f:NetworkTraffic</a>.
    """

    bytes: typing.Optional[int] = pydantic.Field(default=None)
    """
    The total number of bytes (in and out).
    """

    bytes_in: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of bytes sent from the destination to the source.
    """

    bytes_out: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of bytes sent from the source to the destination.
    """

    chunks: typing.Optional[int] = pydantic.Field(default=None)
    """
    The total number of chunks (in and out).
    """

    chunks_in: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of chunks sent from the destination to the source.
    """

    chunks_out: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of chunks sent from the source to the destination.
    """

    packets: typing.Optional[int] = pydantic.Field(default=None)
    """
    The total number of packets (in and out).
    """

    packets_in: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of packets sent from the destination to the source.
    """

    packets_out: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of packets sent from the source to the destination.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
