# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Organization(UncheckedBaseModel):
    """
    The Organization object describes characteristics of an organization or company and its division if any.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the organization. For example, Widget, Inc.
    """

    ou_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the organizational unit, within an organization. For example, Finance, IT, R&D
    """

    ou_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The alternate identifier for an entity's unique identifier. For example, its Active Directory OU DN or AWS OU ID.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the organization. For example, its Active Directory or AWS Org ID.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
