# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .feature import Feature
from ...base.types.url_string import UrlString
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Product(UncheckedBaseModel):
    """
    The Product object describes characteristics of a software product.
    """

    cpe_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Common Platform Enumeration (CPE) name as described by (<a target='_blank' href='https://nvd.nist.gov/products/cpe'>NIST</a>) For example: <code>cpe:/a:apple:safari:16.2</code>.
    """

    distribution_mode: typing.Optional[str] = pydantic.Field(default=None)
    """
    Indicates the source from which the app was installed, such as the app store.
    """

    feature: typing.Optional[Feature] = pydantic.Field(default=None)
    """
    The feature that reported the event.
    """

    lang: typing.Optional[str] = pydantic.Field(default=None)
    """
    The two letter lower case language codes, as defined by <a target='_blank' href='https://en.wikipedia.org/wiki/ISO_639-1'>ISO 639-1</a>. For example: <code>en</code> (English), <code>de</code> (German), or <code>fr</code> (French).
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the product.
    """

    path: typing.Optional[str] = pydantic.Field(default=None)
    """
    The installation path of the product.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the product.
    """

    url_string: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The URL pointing towards the product.
    """

    vendor_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the vendor of the product.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the product, as defined by the event source. For example: <code>2013.1.3-beta</code>.
    """

    workload: typing.Optional[str] = pydantic.Field(default=None)
    """
    The product workload associated with the event.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
