# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from ...base.types.url_string import UrlString
import pydantic
from .ticket_type_id import TicketTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Ticket(UncheckedBaseModel):
    """
    The Ticket object represents ticket in the customer's systems like Salesforce, jira etc.
    """

    src_url: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The url of a ticket in the ticket system.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The title of the ticket.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The linked ticket type determines whether the ticket is internal or in an external ticketing system.
    """

    type_id: typing.Optional[TicketTypeId] = pydantic.Field(default=None)
    """
    The normalized identifier for the ticket type.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique ticket identifier like ticket id.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
