# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Image(UncheckedBaseModel):
    """
    The Image object provides a description of a specific Virtual Machine (VM) or Container image. Defined by D3FEND <a target='_blank' href='https://d3fend.mitre.org/dao/artifact/d3f:ContainerImage/'>d3f:ContainerImage</a>.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The image labels.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The image name. For example: <code>elixir</code>.
    """

    path: typing.Optional[str] = pydantic.Field(default=None)
    """
    The full path to the image file.
    """

    tag: typing.Optional[str] = pydantic.Field(default=None)
    """
    The image tag. For example: <code>1.11-alpine</code>.
    """

    uid: str = pydantic.Field()
    """
    The unique image ID. For example: <code>77af4d6b9913</code>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
