# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .file import File
from .module_load_type_id import ModuleLoadTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Module(UncheckedBaseModel):
    """
    The Module object describes the load attributes of a module.
    """

    base_address: typing.Optional[str] = pydantic.Field(default=None)
    """
    The memory address where the module was loaded.
    """

    file: typing.Optional[File] = pydantic.Field(default=None)
    """
    The module file object.
    """

    function_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The entry-point function of the module. The system calls the entry-point function whenever a process or thread loads or unloads the module.
    """

    load_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The load type, normalized to the caption of the load_type_id value. In the case of 'Other', it is defined by the event source.
    """

    load_type_id: ModuleLoadTypeId = pydantic.Field()
    """
    The normalized identifier for how the module was loaded in memory.
    """

    start_address: typing.Optional[str] = pydantic.Field(default=None)
    """
    The start address of the execution.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The module type.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
