# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .account_type_id import AccountTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Account(UncheckedBaseModel):
    """
    The Account object contains details about the account that initiated or performed a specific activity within a system or application.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The list of labels/tags associated to the account.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the account (e.g. GCP Account Name).
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The account type, normalized to the caption of 'account_type_id'. In the case of 'Other', it is defined by the event source.
    """

    type_id: typing.Optional[AccountTypeId] = pydantic.Field(default=None)
    """
    The normalized account type identifier.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the account (e.g. AWS Account ID).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
