# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ...base.types.url_string import UrlString
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class WebResource(UncheckedBaseModel):
    """
    The Web Resource object describes characteristics of a web resource that was affected by the activity/event.
    """

    data: typing.Optional[typing.Optional[typing.Any]] = pydantic.Field(default=None)
    """
    Details of the web resource, e.g, <code>file</code> details, <code>search</code> results or application-defined resource.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the web resource.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The list of labels/tags associated to a resource.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the web resource.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The web resource type as defined by the event source.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the web resource.
    """

    url_string: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The URL pointing towards the source of the web resource.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
