# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .fingerprint_algorithm_id import FingerprintAlgorithmId
from ...base.types.hash import Hash
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Fingerprint(UncheckedBaseModel):
    """
    The Fingerprint object provides detailed information about a digital fingerprint, which is a compact representation of data used to identify a longer piece of information, such as a public key or file content. It contains the algorithm and value of the fingerprint, enabling efficient and reliable identification of the associated data.
    """

    algorithm: typing.Optional[str] = pydantic.Field(default=None)
    """
    The hash algorithm used to create the digital fingerprint, normalized to the caption of <code>algorithm_id</code>. In the case of <code>Other</code>, it is defined by the event source.
    """

    algorithm_id: FingerprintAlgorithmId = pydantic.Field()
    """
    The identifier of the normalized hash algorithm, which was used to create the digital fingerprint.
    """

    value: Hash = pydantic.Field()
    """
    The digital fingerprint value.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
