# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Edge(UncheckedBaseModel):
    """
    Represents a connection or relationship between two nodes in a graph.
    """

    data: typing.Optional[typing.Optional[typing.Any]] = pydantic.Field(default=None)
    """
    Additional data about the edge such as weight, distance, or custom properties.
    """

    is_directed: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether the edge is (<code>true</code>) or undirected (<code>false</code>).
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The human-readable name or label for the edge.
    """

    relation: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of relationship between nodes (e.g. is-attached-to , depends-on, etc).
    """

    source: str = pydantic.Field()
    """
    The unique identifier of the node where the edge originates.
    """

    target: str = pydantic.Field()
    """
    The unique identifier of the node where the edge terminates.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier of the edge.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
