# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class LongString(UncheckedBaseModel):
    """
    This object is a used to capture strings which may be truncated by a security product due to their length.
    """

    is_truncated: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates that <code>value</code> has been truncated. May be omitted if truncation has not occurred.
    """

    untruncated_size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The size in bytes of the string represented by <code>value</code> before truncation. Should be omitted if truncation has not occurred.
    """

    value: str = pydantic.Field()
    """
    The string value, truncated if <code>is_truncated</code> is <code>true</code>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
