# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Node(UncheckedBaseModel):
    """
    Represents a node or a vertex in a graph structure.
    """

    data: typing.Optional[typing.Optional[typing.Any]] = pydantic.Field(default=None)
    """
    Additional data about the node stored as key-value pairs. Can include custom properties specific to the node.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    A human-readable description of the node's purpose or meaning in the graph.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A human-readable name or label for the node. Should be descriptive and unique within the graph context.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Categorizes the node into a specific class or type. Useful for grouping and filtering nodes.
    """

    uid: str = pydantic.Field()
    """
    A unique string or numeric identifier that distinguishes this node from all others in the graph. Must be unique across all nodes.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
