# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .group import Group
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Policy(UncheckedBaseModel):
    """
    The Policy object describes the policies that are applicable. <p>Policy attributes provide traceability to the operational state of the security product at the time that the event was captured, facilitating forensics, troubleshooting, and policy tuning/adjustments.</p>
    """

    data: typing.Optional[typing.Optional[typing.Any]] = pydantic.Field(default=None)
    """
    Additional data about the policy such as the underlying JSON policy itself or other details.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the policy.
    """

    group: typing.Optional[Group] = pydantic.Field(default=None)
    """
    The policy group.
    """

    is_applied: typing.Optional[bool] = pydantic.Field(default=None)
    """
    A determination if the content of a policy was applied to a target or request, or not.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The policy name. For example: <code>IAM Policy</code>.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    A unique identifier of the policy instance.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The policy version number.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
