# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .action_id import ActionId
from .activity_id import ActivityId
from ...objects.types.actor import Actor
from ...objects.types.api import Api
from ...objects.types.attack import Attack
from ...objects.types.authorization import Authorization
from .category_uid import CategoryUid
from .class_uid import ClassUid
from ...objects.types.cloud import Cloud
from .confidence_id import ConfidenceId
from ...objects.types.object import Object
from ...objects.types.device import Device
from .direction_id import DirectionId
from .disposition_id import DispositionId
from ...objects.types.network_endpoint import NetworkEndpoint
from ...objects.types.email import Email
from ...objects.types.email_auth import EmailAuth
from ...base.types.timestamp import Timestamp
import datetime as dt
from ...objects.types.enrichment import Enrichment
from ...objects.types.firewall_rule import FirewallRule
from ...base.types.email_address import EmailAddress
from ...objects.types.malware import Malware
from ...objects.types.malware_scan_info import MalwareScanInfo
from ...objects.types.metadata import Metadata
from ...objects.types.observable import Observable
from ...objects.types.osint import Osint
from ...objects.types.policy import Policy
from ...objects.types.fingerprint import Fingerprint
from .risk_level_id import RiskLevelId
from .severity_id import SeverityId
from .status_id import StatusId
from .type_uid import TypeUid
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class EmailActivity(UncheckedBaseModel):
    """
    Email Activity events report SMTP protocol and email activities including those with embedded URLs and files. See the <code>Email</code> object for details.
    """

    action: typing.Optional[str] = pydantic.Field(default=None)
    """
    The normalized caption of <code>action_id</code>.
    """

    action_id: typing.Optional[ActionId] = pydantic.Field(default=None)
    """
    The action taken by a control or other policy-based system leading to an outcome or disposition. An unknown action may still correspond to a known disposition. Refer to <code>disposition_id</code> for the outcome of the action.
    """

    activity_id: ActivityId = pydantic.Field()
    """
    The normalized identifier of the activity that triggered the event.
    """

    activity_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The event activity name, as defined by the activity_id.
    """

    actor: typing.Optional[Actor] = pydantic.Field(default=None)
    """
    The actor object describes details about the user/role/process that was the source of the activity. Note that this is not the threat actor of a campaign but may be part of a campaign.
    """

    api: typing.Optional[Api] = pydantic.Field(default=None)
    """
    Describes details about a typical API (Application Programming Interface) call.
    """

    attacks: typing.Optional[typing.List[Attack]] = pydantic.Field(default=None)
    """
    An array of MITRE ATT&CK® objects describing identified tactics, techniques & sub-techniques. The objects are compatible with MITRE ATLAS™ tactics, techniques & sub-techniques.
    """

    attempt: typing.Optional[int] = pydantic.Field(default=None)
    """
    The attempt number for attempting to deliver the email.
    """

    authorizations: typing.Optional[typing.List[Authorization]] = pydantic.Field(
        default=None
    )
    """
    Provides details about an authorization, such as authorization outcome, and any associated policies related to the activity/event.
    """

    banner: typing.Optional[str] = pydantic.Field(default=None)
    """
    The initial connection response that a messaging server receives after it connects to an email server.
    """

    category_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The event category name, as defined by category_uid value: <code>Network Activity</code>.
    """

    category_uid: CategoryUid = pydantic.Field()
    """
    The category unique identifier of the event.
    """

    class_uid: ClassUid = pydantic.Field()
    """
    The unique identifier of a class. A class describes the attributes available in an event.
    """

    cloud: typing.Optional[Cloud] = pydantic.Field(default=None)
    """
    Describes details about the Cloud environment where the event was originally created or logged.
    """

    command: typing.Optional[str] = pydantic.Field(default=None)
    """
    The command issued by the initiator (client), such as SMTP HELO or EHLO.
    """

    confidence: typing.Optional[str] = pydantic.Field(default=None)
    """
    The confidence, normalized to the caption of the confidence_id value. In the case of 'Other', it is defined by the event source.
    """

    confidence_id: typing.Optional[ConfidenceId] = pydantic.Field(default=None)
    """
    The normalized confidence refers to the accuracy of the rule that created the finding. A rule with a low confidence means that the finding scope is wide and may create finding reports that may not be malicious in nature.
    """

    confidence_score: typing.Optional[int] = pydantic.Field(default=None)
    """
    The confidence score as reported by the event source.
    """

    count: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of times that events in the same logical group occurred during the event <strong>Start Time</strong> to <strong>End Time</strong> period.
    """

    custom_fields: typing.Optional[Object] = pydantic.Field(default=None)
    """
    A list of custom fields
    """

    device: typing.Optional[Device] = pydantic.Field(default=None)
    """
    An addressable device, computer system or host.
    """

    direction: typing.Optional[str] = pydantic.Field(default=None)
    """
    The direction of the email, as defined by the <code>direction_id</code> value.
    """

    direction_id: DirectionId = pydantic.Field()
    """
    <p>The direction of the email relative to the scanning host or organization.</p>Email scanned at an internet gateway might be characterized as inbound to the organization from the Internet, outbound from the organization to the Internet, or internal within the organization. Email scanned at a workstation might be characterized as inbound to, or outbound from the workstation.
    """

    disposition: typing.Optional[str] = pydantic.Field(default=None)
    """
    The disposition name, normalized to the caption of the disposition_id value. In the case of 'Other', it is defined by the event source.
    """

    disposition_id: typing.Optional[DispositionId] = pydantic.Field(default=None)
    """
    Describes the outcome or action taken by a security control, such as access control checks, malware detections or various types of policy violations.
    """

    dst_endpoint: typing.Optional[NetworkEndpoint] = pydantic.Field(default=None)
    """
    The responder (server) receiving the email.
    """

    duration: typing.Optional[int] = pydantic.Field(default=None)
    """
    The event duration or aggregate time, the amount of time the event covers from <code>start_time</code> to <code>end_time</code> in milliseconds.
    """

    email: Email = pydantic.Field()
    """
    The email object.
    """

    email_auth: typing.Optional[EmailAuth] = pydantic.Field(default=None)
    """
    The SPF, DKIM and DMARC attributes of an email.
    """

    end_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The end time of a time period, or the time of the most recent event included in the aggregate event.
    """

    end_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The end time of a time period, or the time of the most recent event included in the aggregate event.
    """

    enrichments: typing.Optional[typing.List[Enrichment]] = pydantic.Field(default=None)
    """
    The additional information from an external data source, which is associated with the event or a finding. For example add location information for the IP address in the DNS answers:</p><code>[{"name": "answers.ip", "value": "92.24.47.250", "type": "location", "data": {"city": "Socotra", "continent": "Asia", "coordinates": [-25.4153, 17.0743], "country": "YE", "desc": "Yemen"}}]</code>
    """

    firewall_rule: typing.Optional[FirewallRule] = pydantic.Field(default=None)
    """
    The firewall rule that pertains to the control that triggered the event, if applicable.
    """

    from_: typing.Optional[EmailAddress] = pydantic.Field(alias="from", default=None)
    """
    The sender address from the transmission envelope. This reflects the actual sending party and may differ from the 'From' header in the message.
    """

    is_alert: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates that the event is considered to be an alertable signal. Should be set to <code>true</code> if <code>disposition_id = Alert</code> among other dispositions, and/or <code>risk_level_id</code> or <code>severity_id</code> of the event is elevated. Not all control events will be alertable, for example if <code>disposition_id = Exonerated</code> or <code>disposition_id = Allowed</code>.
    """

    malware: typing.Optional[typing.List[Malware]] = pydantic.Field(default=None)
    """
    A list of Malware objects, describing details about the identified malware.
    """

    malware_scan_info: typing.Optional[MalwareScanInfo] = pydantic.Field(default=None)
    """
    Describes details about the scan job that identified malware on the target system.
    """

    message: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the event/finding, as defined by the source.
    """

    message_trace_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The identifier that tracks a message that travels through multiple points of a messaging service.
    """

    metadata: Metadata = pydantic.Field()
    """
    The metadata associated with the event or a finding.
    """

    observables: typing.Optional[typing.List[Observable]] = pydantic.Field(default=None)
    """
    The observables associated with the event or a finding.
    """

    osint: typing.Optional[typing.List[Osint]] = pydantic.Field(default=None)
    """
    The OSINT (Open Source Intelligence) object contains details related to an indicator such as the indicator itself, related indicators, geolocation, registrar information, subdomains, analyst commentary, and other contextual information. This information can be used to further enrich a detection or finding by providing decisioning support to other analysts and engineers.
    """

    policy: typing.Optional[Policy] = pydantic.Field(default=None)
    """
    The policy that pertains to the control that triggered the event, if applicable. For example the name of an anti-malware policy or an access control policy.
    """

    protocol_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Protocol Name specifies the email communication protocol, such as SMTP, IMAP, or POP3.
    """

    raw_data: typing.Optional[str] = pydantic.Field(default=None)
    """
    The raw event/finding data as received from the source.
    """

    raw_data_hash: typing.Optional[Fingerprint] = pydantic.Field(default=None)
    """
    The hash, which describes the content of the raw_data field.
    """

    raw_data_size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The size of the raw data which was transformed into an OCSF event, in bytes.
    """

    risk_details: typing.Optional[str] = pydantic.Field(default=None)
    """
    Describes the risk associated with the finding.
    """

    risk_level: typing.Optional[str] = pydantic.Field(default=None)
    """
    The risk level, normalized to the caption of the risk_level_id value.
    """

    risk_level_id: typing.Optional[RiskLevelId] = pydantic.Field(default=None)
    """
    The normalized risk level id.
    """

    risk_score: typing.Optional[int] = pydantic.Field(default=None)
    """
    The risk score as reported by the event source.
    """

    severity: typing.Optional[str] = pydantic.Field(default=None)
    """
    The event/finding severity, normalized to the caption of the <code>severity_id</code> value. In the case of 'Other', it is defined by the source.
    """

    severity_id: SeverityId = pydantic.Field()
    """
    <p>The normalized identifier of the event/finding severity.</p>The normalized severity is a measurement the effort and expense required to manage and resolve an event or incident. Smaller numerical values represent lower impact events, and larger numerical values represent higher impact events.
    """

    smtp_hello: typing.Optional[str] = pydantic.Field(default=None)
    """
    The value of the SMTP HELO or EHLO command sent by the initiator (client).
    """

    src_endpoint: typing.Optional[NetworkEndpoint] = pydantic.Field(default=None)
    """
    The initiator (client) sending the email.
    """

    start_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The start time of a time period, or the time of the least recent event included in the aggregate event.
    """

    start_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The start time of a time period, or the time of the least recent event included in the aggregate event.
    """

    status: typing.Optional[str] = pydantic.Field(default=None)
    """
    The event status, normalized to the caption of the status_id value. In the case of 'Other', it is defined by the event source.
    """

    status_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    The event status code, as reported by the event source.<br /><br />For example, in a Windows Failed Authentication event, this would be the value of 'Failure Code', e.g. 0x18.
    """

    status_detail: typing.Optional[str] = pydantic.Field(default=None)
    """
    The status detail contains additional information about the event/finding outcome.
    """

    status_id: typing.Optional[StatusId] = pydantic.Field(default=None)
    """
    The normalized identifier of the event status.
    """

    time: Timestamp = pydantic.Field()
    """
    The normalized event occurrence time or the finding creation time.
    """

    time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The normalized event occurrence time or the finding creation time.
    """

    timezone_offset: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of minutes that the reported event <code>time</code> is ahead or behind UTC, in the range -1,080 to +1,080.
    """

    to: typing.Optional[typing.List[EmailAddress]] = pydantic.Field(default=None)
    """
    The recipient address from the transmission envelope. This may differ from the 'To' header and represents where the message was actually delivered.
    """

    type_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The event/finding type name, as defined by the type_uid.
    """

    type_uid: TypeUid = pydantic.Field()
    """
    The event/finding type ID. It identifies the event's semantics and structure. The value is calculated by the logging system as: <code>class_uid \* 100 + activity_id</code>.
    """

    unmapped: typing.Optional[Object] = pydantic.Field(default=None)
    """
    The attributes that are not mapped to the event schema. The names and values of those attributes are specific to the event source.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
