# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .key_value_object import KeyValueObject
from .account_type_id import AccountTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Account(UncheckedBaseModel):
    """
    The Account object contains details about the account that initiated or performed a specific activity within a system or application. Additionally, the Account object refers to logical Cloud and Software-as-a-Service (SaaS) based containers such as AWS Accounts, Azure Subscriptions, Oracle Cloud Compartments, Google Cloud Projects, and otherwise.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The list of labels associated to the account.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the account (e.g. <code> GCP Project name </code>, <code> Linux Account name </code> or <code> AWS Account name</code>).
    """

    tags: typing.Optional[typing.List[KeyValueObject]] = pydantic.Field(default=None)
    """
    The list of tags; <code>{key:value}</code> pairs associated to the account.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The account type, normalized to the caption of 'account_type_id'. In the case of 'Other', it is defined by the event source.
    """

    type_id: typing.Optional[AccountTypeId] = pydantic.Field(default=None)
    """
    The normalized account type identifier.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the account (e.g. <code> AWS Account ID </code>, <code> OCID </code>, <code> GCP Project ID </code>, <code> Azure Subscription ID </code>, <code> Google Workspace Customer ID </code>, or <code> M365 Tenant UID</code>).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
