# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
from ...base.types.port import Port
import pydantic
import typing
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class PortInfo(UncheckedBaseModel):
    """
    The Port Information object describes a port and its associated protocol details.
    """

    port: Port = pydantic.Field()
    """
    The port number. For example: <code>80</code>, <code>443</code>, <code>22</code>.
    """

    protocol_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The IP protocol name in lowercase, as defined by the Internet Assigned Numbers Authority (IANA). For example: <code>tcp</code> or <code>udp</code>.
    """

    protocol_num: typing.Optional[int] = pydantic.Field(default=None)
    """
    The IP protocol number, as defined by the Internet Assigned Numbers Authority (IANA). For example: <code>6</code> for TCP and <code>17</code> for UDP.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
