# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .kill_chain_phase_phase_id import KillChainPhasePhaseId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class KillChainPhase(UncheckedBaseModel):
    """
    The Kill Chain Phase object represents a single phase of a cyber attack, including the initial reconnaissance and planning stages up to the final objective of the attacker. It provides a detailed description of each phase and its associated activities within the broader context of a cyber attack. See <a target='_blank' href='https://www.lockheedmartin.com/en-us/capabilities/cyber/cyber-kill-chain.html'>Cyber Kill Chain®</a>.
    """

    phase: typing.Optional[str] = pydantic.Field(default=None)
    """
    The cyber kill chain phase.
    """

    phase_id: KillChainPhasePhaseId = pydantic.Field()
    """
    The cyber kill chain phase identifier.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
