# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from .common_properties import CommonProperties
import pydantic
import typing
from ...open_vocab.types.identity_class_ov import IdentityClassOv
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.pydantic_utilities import update_forward_refs


class Identity(CommonProperties):
    type: str = pydantic.Field()
    """
    The value of this property MUST be identity.
    """

    name: str = pydantic.Field()
    """
    The name of this Identity. When referring to a specific entity (e.g., an individual or organization), this property SHOULD contain the canonical name of the specific entity.
    """

    description: typing.Optional[str] = None
    roles: typing.Optional[str] = pydantic.Field(default=None)
    """
    The list of roles that this Identity performs. No open vocabulary is yet defined for this property.
    """

    identity_class: typing.Optional[IdentityClassOv] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


update_forward_refs(Identity)
