# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .note_id import NoteId
from .ticket_id import TicketId
import pydantic
import datetime as dt
import typing
from ...engine.types.object import Object
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Note(UncheckedBaseModel):
    """
    Note on a ticket
    """

    id: NoteId
    ticket_id: TicketId
    content: str = pydantic.Field()
    """
    The content of the note formatted as markdown.
    """

    creator: str = pydantic.Field()
    """
    The user who created the note.
    """

    title: str = pydantic.Field()
    """
    The title of the note.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    The date the comment was created.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date the comment was last updated.
    """

    custom_fields: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = (
        pydantic.Field(default=None)
    )
    """
    Custom mapped fields for this note.
    """

    unmapped: typing.Optional[Object] = pydantic.Field(default=None)
    """
    The attributes that are not mapped to the comment schema. The names and values of those attributes are specific to the provider.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
