# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from ...engine.types.object import Object
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Project(UncheckedBaseModel):
    """
    Project in a ticketing system
    """

    id: str = pydantic.Field()
    """
    Unique identifier for this project. Use this id in the `project` field of a `Ticket`.
    """

    name: str = pydantic.Field()
    """
    Name of the project
    """

    custom_fields: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = (
        pydantic.Field(default=None)
    )
    """
    Custom mapped fields for this project.
    """

    unmapped: typing.Optional[Object] = pydantic.Field(default=None)
    """
    The attributes that are not mapped to the project schema. The names and values of those attributes are specific to the provider.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
