# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from .remote_field_schema import RemoteFieldSchema
from .remote_field_scope import RemoteFieldScope
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class RemoteField(UncheckedBaseModel):
    field_id: str = pydantic.Field()
    """
    Remote ID of the field.
    """

    schema_: typing.Optional[RemoteFieldSchema] = pydantic.Field(
        alias="schema", default=None
    )
    """
    Schema of the field.
    """

    field_scope: RemoteFieldScope = pydantic.Field()
    """
    Scope of remote field - standard or some kind of customization?
    """

    provider_field_name: str = pydantic.Field()
    """
    Name of field in the remote ticketing provider.
    """

    provider_field_path: typing.Optional[str] = pydantic.Field(default=None)
    """
    Path to the field in the remote ticketing provider. Uses dot notation for nested fields.
    """

    project_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Project id to which this field is scoped to
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
