# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import datetime as dt
import pydantic
from .bridge_local_config import BridgeLocalConfig
from .bridge_local_stats import BridgeLocalStats
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class BridgeStatus(UncheckedBaseModel):
    current_time: dt.datetime = pydantic.Field()
    """
    Local time on the Bridge when the status check was performed.
    """

    response_duration: str = pydantic.Field()
    """
    Round trip time for the status check.
    """

    local_config: BridgeLocalConfig = pydantic.Field()
    """
    Local configuration parameters for the Bridge.
    """

    local_stats: BridgeLocalStats = pydantic.Field()
    """
    Local bridge statistics
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
