# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.unchecked_base_model import UncheckedBaseModel
from ...capabilities_base.types.category_id import CategoryId
import pydantic
import typing
from ...capabilities_base.types.provider_id import ProviderId
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.pydantic_utilities import update_forward_refs


class Connector(UncheckedBaseModel):
    """
    Provides details of the Connector.
    """

    id: CategoryId = pydantic.Field()
    """
    Unique identifier for the Connector.
    """

    name: CategoryId = pydantic.Field()
    """
    Name of the connector.
    """

    fullname: str = pydantic.Field()
    """
    Display name of the Connector.
    """

    description: str = pydantic.Field()
    """
    Description of the Connector.
    """

    provider_ids: typing.List[ProviderId] = pydantic.Field()
    """
    List of Providers that implement the Connector.
    """

    providers: typing.Optional[typing.List["ProviderCapabilities"]] = pydantic.Field(
        default=None
    )
    """
    List of capabilities for Providers that implement the Connector.
    """

    connector: typing.Optional[CategoryId] = pydantic.Field(default=None)
    """
    DEPRECATED – use `id` instead.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


from .provider_capabilities import ProviderCapabilities  # noqa: E402

update_forward_refs(Connector)
