# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
from .filter_type import FilterType
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ProviderFilter(UncheckedBaseModel):
    name: str = pydantic.Field()
    """
    Name of the filter.
    """

    type: FilterType = pydantic.Field()
    """
    Type of the value that this filter can apply to
    """

    operators: typing.List[str] = pydantic.Field()
    """
    List of operators that this filter supports.
    """

    values: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of possible values for this filter.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
