# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class RequestBody(UncheckedBaseModel):
    """
    Describes the request body and its schema.
    """

    required: bool = pydantic.Field()
    """
    If true the request body is required, false otherwise.
    """

    schema_: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = (
        pydantic.Field(alias="schema", default=None)
    )
    """
    The schema defining the type used for the request body. If
    expanded will be a full JSON schema of the entire request body,
    otherwise this will be a reference object. The reference object
    has a single key `$ref`, which is a URI [RFC3986] identifying the
    location of a component within the Engine OpenAPI specification.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
