# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .patch_op import PatchOp
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class PatchOperation(UncheckedBaseModel):
    """
    JSON patch to apply. A JSON patch is a list of patch operations. (see https://jsonpatch.com/)
    """

    op: PatchOp = pydantic.Field()
    """
    The operation to perform. Supported values are `add`, `copy`, `move`, `replace`, `remove`, and `test`.
    """

    path: str = pydantic.Field()
    """
    The path to the field to update. The path is a JSON Pointer.
    """

    from_: typing.Optional[str] = pydantic.Field(alias="from", default=None)
    """
    The path to the field to copy from. This is required for `copy` and `move` operations.
    """

    value: typing.Optional[typing.Optional[typing.Any]] = pydantic.Field(default=None)
    """
    The value to set the field to. This is required for `add`, `replace` and `test` operations.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
