# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from .problem_context import ProblemContext
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ProblemDetails(UncheckedBaseModel):
    message: str = pydantic.Field()
    """
    A short, display-friendly summary of the problem.
    """

    detail: typing.Optional[str] = pydantic.Field(default=None)
    """
    A display-friendly and more detailed explanation of the problem. It may offer additional contextual detail, but may also be just a generic description of the problem.
    """

    remediation: typing.Optional[str] = pydantic.Field(default=None)
    """
    A display-friendly explanation for how to remediate the problem. This field may be omitted in case there are multiple problems, each with its own remediation, or if no remediation is possible.
    """

    context: typing.Optional[ProblemContext] = pydantic.Field(default=None)
    """
    Additional context providing further detail about the problem, such as a problematic input parameter and/or a list of related resources.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
