# This file was auto-generated by Fern from our API Definition.

from ...common.types.base import Base
from .integration_point_id import IntegrationPointId
import typing
import pydantic
from ...capabilities_base.types.category_id import CategoryId
from .integration_environments import IntegrationEnvironments
from .mapping_chain_template import MappingChainTemplate
from .additional_mapping_template import AdditionalMappingTemplate
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class IntegrationPoint(Base):
    """
    Enables creation, editing and deletion of Integrations.
    """

    id: IntegrationPointId
    fullname: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of integration point, will be shown to end-users in the Connect UI.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional description of the Integration Point. Will not be displayed to end-users of Connect UI.
    """

    connector: CategoryId = pydantic.Field()
    """
    Connector to use for the Integration Point.
    """

    environments: IntegrationEnvironments = pydantic.Field()
    """
    Selects providers to use for account environments.
    """

    mappings: typing.Optional[typing.List[MappingChainTemplate]] = pydantic.Field(
        default=None
    )
    """
    A list of mapping chains to apply to integrations using this integration point. Each mapping chain is a list of mappings to apply to the integration in the order they should be applied. Mappings are applied by operation ID. If an integration is created that declares its own mappings for an operation, they will override this list of mappings. Leave this empty to use the default default mappings.
    """

    additional_mappings: typing.Optional[typing.List[AdditionalMappingTemplate]] = (
        pydantic.Field(default=None)
    )
    """
    Additional data mappings for integrations added to this integration point. This allows for custom data to be mapped to the custom_fields portion of the response.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
