# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from ...role_base.types.role_name import RoleName
from .member_options import MemberOptions
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CreateMemberRequest(UncheckedBaseModel):
    name: str = pydantic.Field()
    """
    Email name to use for this Member. Also used for duplicate detection and default sort order.
    """

    fullname: typing.Optional[str] = pydantic.Field(default=None)
    """
    User's full display name. Defaults to the same value as the 'name' field if not specified.
    """

    nickname: typing.Optional[str] = pydantic.Field(default=None)
    """
    User's nickname
    """

    picture: typing.Optional[str] = pydantic.Field(default=None)
    """
    Url of user's picture
    """

    secret: str = pydantic.Field()
    """
    Member secret used to logon. Must be at least 8 characters long and fewer than 72 characters. There are no restrictions on the characters used; however, the secret must be sufficiently complex. It cannot be a common word, previously leaked password, or easily guessed sequences like `qwerty` or `12345`.
    """

    role_binding: typing.Optional[typing.List[RoleName]] = pydantic.Field(default=None)
    """
    Roles granted to this member. Tokens inherit this access. Defaults to `member`.
    """

    options: MemberOptions

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
