# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from .options import Options
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class MemberOptions(UncheckedBaseModel):
    ttl: str = pydantic.Field()
    """
    Optional member time-to-live duration. After a member expires, system requires a change password to re-enable member. Minimum 1 day, Maximum 1 year, Default 180 days.
    """

    options: typing.List[Options] = pydantic.Field()
    """
    Options: "expired" will force change password on first logon.
    """

    token_ttl: str = pydantic.Field()
    """
    Optional token time-to-live duration. Tokens are created for this member with this duration as their TTL. Minimum 10 miniutes, Maximum 1 week, Defaults 1 hour.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
