# This file was auto-generated by Fern from our API Definition.

from ...common.types.base import Base
from .organization_id import OrganizationId
from ...token_base.types.token_id import TokenId
import pydantic
from .organization_type import OrganizationType
import typing
from .organization_options import OrganizationOptions
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Organization(Base):
    id: OrganizationId
    refresh_token_id: TokenId = pydantic.Field()
    """
    Organization refresh token id
    """

    organization_type: OrganizationType = pydantic.Field()
    """
    Organization type: root or standard
    """

    fullname: str = pydantic.Field()
    """
    Human friendly display name for this Organization
    """

    contact: typing.Optional[str] = pydantic.Field(default=None)
    """
    Organization email address
    """

    reply_to: typing.Optional[str] = pydantic.Field(default=None)
    """
    Reply-to email address, used for SMTP emails. Defaults to no-reply@synqly.com
    """

    picture: typing.Optional[str] = pydantic.Field(default=None)
    """
    Picture URL of the organization
    """

    options: typing.Optional[OrganizationOptions] = pydantic.Field(default=None)
    """
    Organization options
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
