# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class CustomFieldMapping(UncheckedBaseModel):
    name: str = pydantic.Field()
    """
    Name for the custom field that you will use in the `custom_fields` field in the returned ticket objects.
    """

    project_id: str = pydantic.Field()
    """
    ID of the project this field mapping is associated with. ID of "\*" is used to apply to all projects.
    """

    provider_field_path: str = pydantic.Field()
    """
    Path to or name of the custom field in the provider.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
