# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .sentinel_one_credential import SentinelOneCredential
import typing
from .sentinel_one_edr_events_credential import SentinelOneEdrEventsCredential
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class EdrSentinelOne(UncheckedBaseModel):
    """
    Configuration for SentinelOne Singularity™ Endpoint.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/sentinelone-setup)
    """

    credential: SentinelOneCredential
    edr_events_credential: typing.Optional[SentinelOneEdrEventsCredential] = (
        pydantic.Field(default=None)
    )
    """
    Credential used for the SentinelOne Singularity Data Lake API. This credential is required when querying EDR events.
    """

    edr_events_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base URL for the SentinelOne Singularity Data Lake API. This URL is required is required when querying EDR events.
    """

    skip_tls_verify: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When true, skips verification of the SentinelOne TLS certificate.
    """

    url: str = pydantic.Field()
    """
    Base URL for the SentinelOne Management API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
