# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .elasticsearch_shared_secret import ElasticsearchSharedSecret
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ElasticsearchAuthOptions(UncheckedBaseModel):
    """
    Options used to control how requests are made to Elasticsearch when different authentication types are used.
    """

    run_as: typing.Optional[str] = pydantic.Field(default=None)
    """
    Submit API requests as a specific user, with all of their roles and permissions. When populated, this option will send the `es-security-runas-user` header with every request made to the Elasticsearch API.
    """

    shared_secret: typing.Optional[ElasticsearchSharedSecret] = pydantic.Field(
        default=None
    )
    """
    Some auth cases, notably JWT auth, can be configured to require sending a shared secret in the `ES-Client-Authentication` header. When this secret is populated it will get added as the shared secret for every request made to Elasticsearch.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
