# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .sumo_logic_collection_url import SumoLogicCollectionUrl
from .sumo_logic_credential import SumoLogicCredential
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class SiemSumoLogic(UncheckedBaseModel):
    """
    Configuration for Sumo Logic Cloud SIEM.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/sumo-logic-setup)
    """

    auto_parse_logs: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Automatically parse logs as JSON when running log queries.
    """

    collection_url: typing.Optional[SumoLogicCollectionUrl] = pydantic.Field(
        default=None
    )
    """
    Secure Sumo Logic Collection URL for writing events. If not provided, sending events to Sumo Logic is disabled.
    """

    credential: SumoLogicCredential
    siem_logs_only: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Only query for logs that have been processed into the Sumo Logic Cloud SIEM app.
    """

    url: str = pydantic.Field()
    """
    Base URL for the Sumo Logic API.
    [Sumo Logic endpoints by deployment and firewall security](https://help.sumologic.com/docs/api/getting-started/#sumo-logic-endpoints-by-deployment-and-firewall-security).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
