# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
from .aws_s_3_credential import AwsS3Credential
from .aws_region import AwsRegion
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class SinkAwsS3(UncheckedBaseModel):
    """
    Configuration for Amazon S3 as a Sink provider. Events are written directly to an AWS S3 bucket in compressed JSON format.
    """

    bucket: str = pydantic.Field()
    """
    Bucket
    """

    credential: AwsS3Credential = pydantic.Field()
    """
    Credential
    """

    path: str = pydantic.Field()
    """
    Path
    """

    region: AwsRegion = pydantic.Field()
    """
    AWS Region
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
