# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .aws_security_lake_credential import AwsSecurityLakeCredential
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class SinkAwsSecurityLake(UncheckedBaseModel):
    """
    Configuration for Amazon Security Lake as a Sink provider. Events are written directly to an AWS S3 bucket in Apache Parquet format.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/amazon-security-lake-sink-setup)
    """

    credential: AwsSecurityLakeCredential = pydantic.Field()
    """
    AWS Access Keys with write access to the configured S3 bucket.
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    Override the default AWS region for this integration. If not present, the region will be inferred from the URL.
    """

    url: str = pydantic.Field()
    """
    URL of the S3 bucket where the Amazon Security Lake events are stored.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
