# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .aws_sqs_credential import AwsSqsCredential
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class SinkAwsSqs(UncheckedBaseModel):
    """
    Configuration for Amazon Simple Queue Service (SQS).

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/aws-sqs-sink-setup)
    """

    credential: AwsSqsCredential = pydantic.Field()
    """
    AWS Access Keys with write access to the configured SQS queue.
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    Overrides the default AWS region. If not present, the region will be inferred from the URL.
    """

    url: str = pydantic.Field()
    """
    URL of the SQS queue where events are sent.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
