# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
from .azure_monitor_logs_credential import AzureMonitorLogsCredential
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class SinkAzureMonitorLogs(UncheckedBaseModel):
    """
    Configuration for Azure Monitor Logs as a Sink Provider. Azure Monitor Logs is a feature of Azure Monitor that collects and organizes log and performance data from monitored resources.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/azure-monitor-logs)
    """

    client_id: str = pydantic.Field()
    """
    Azure Client (Application) ID.
    """

    credential: AzureMonitorLogsCredential = pydantic.Field()
    """
    Credential with access to the configured data collection endpoint.
    """

    rule_id: str = pydantic.Field()
    """
    Data collection rule immutable ID.
    """

    stream_name: str = pydantic.Field()
    """
    Name of the data collection rule stream.
    """

    tenant_id: str = pydantic.Field()
    """
    Azure Directory (tenant) ID.
    """

    url: str = pydantic.Field()
    """
    URL of the Azure data collection endpoint.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
