# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .splunk_hec_token import SplunkHecToken
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class SinkSplunk(UncheckedBaseModel):
    """
    Configuration for Splunk as a Sink provider. Allows sending data to Splunk using an HTTP Event Collector (HEC).

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/splunk-setup)
    """

    hec_credential: SplunkHecToken = pydantic.Field()
    """
    Credential to use when connecting to the Splunk HEC service. If not provided, sending events to Splunk is disabled.
    """

    hec_url: str = pydantic.Field()
    """
    URL for the Splunk HEC endpoint. Must include the full path to the HEC endpoint.
    """

    index: typing.Optional[str] = pydantic.Field(default=None)
    """
    Splunk index to send events to. If not provided, will use the default index for the Splunk collector.
    """

    skip_tls_verify: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When true, skips verification of the Splunk TLS certificate.
    """

    source: typing.Optional[str] = pydantic.Field(default=None)
    """
    Splunk source to send events to. If not provided the default source for the Splunk collector is used.
    """

    source_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Splunk source type to send events to. If not provided the default source type for the Splunk collector is used.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
