# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .autotask_api_integration_code_credential import (
    AutotaskApiIntegrationCodeCredential,
)
from .autotask_secret_credential import AutotaskSecretCredential
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class TicketingAutotask(UncheckedBaseModel):
    """
    Configuration for Autotask Operations Cloud.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/autotask-ticketing-setup)
    """

    api_integration_code_credential: AutotaskApiIntegrationCodeCredential
    secret_credential: AutotaskSecretCredential
    user_name: str = pydantic.Field()
    """
    User name of the API User created to authenticate with the Autotask API.
    """

    zone_path: str = pydantic.Field()
    """
    Zone for the Autotask API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
