# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from ...account_base.types.account_id import AccountId
import pydantic
from ...integration_base.types.integration_id import IntegrationId
import datetime as dt
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class StatusEvent(UncheckedBaseModel):
    """
    Status event object
    """

    account_id: AccountId = pydantic.Field()
    """
    Account owner
    """

    integration_id: IntegrationId = pydantic.Field()
    """
    Integration object
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Time created
    """

    status: str = pydantic.Field()
    """
    The current status of the notification.
    """

    error: typing.Optional[str] = pydantic.Field(default=None)
    """
    Error message
    """

    request: int = pydantic.Field()
    """
    Request number
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
