# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
import datetime as dt
from ...permissions.types.permission import Permission
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class Token(UncheckedBaseModel):
    secret: str = pydantic.Field()
    """
    Secret value for the token; used for authentication when making requests.
    """

    expires: dt.datetime = pydantic.Field()
    """
    Time when this token expires and can no longer be used again.
    """

    permissions: Permission = pydantic.Field()
    """
    Permissions granted to this token.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
